/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.standalone;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonarsource.sonarlint.core.plugin.PluginIndexProvider;

public class StandalonePluginIndexProvider
implements PluginIndexProvider {
    private final List<URL> pluginUrls;

    public StandalonePluginIndexProvider(List<URL> pluginUrls) {
        this.pluginUrls = pluginUrls;
    }

    @Override
    public List<PluginIndexProvider.PluginReference> references() {
        return Lists.transform(this.pluginUrls, new UrlToPluginReference());
    }

    private static final class UrlToPluginReference
    implements Function<URL, PluginIndexProvider.PluginReference> {
        private UrlToPluginReference() {
        }

        @Override
        public PluginIndexProvider.PluginReference apply(URL input) {
            return UrlToPluginReference.toPlugin(input);
        }

        private static PluginIndexProvider.PluginReference toPlugin(URL input) {
            try {
                PluginIndexProvider.PluginReference ref = new PluginIndexProvider.PluginReference();
                try (InputStream is = input.openStream();){
                    ref.setHash(DigestUtils.md5Hex(is));
                }
                ref.setDownloadUrl(input);
                ref.setFilename(StringUtils.substringAfterLast(input.getFile(), "/"));
                return ref;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load local plugins", e);
            }
        }
    }
}

